/**
 * @(#)ChangeConfigMapper.java, 2022/11/11.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.mapper;

import com.netease.mail.yanxuan.change.dal.entity.ChangeType;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeConfigPo;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigQueryReq;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Mapper;
import com.netease.mail.yanxuan.change.dal.entity.ChangeConfig;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import java.util.List;

/**
 * @Author zcwang
 * @Date 2022/11/11
 */
@Mapper
public interface ChangeConfigMapper extends tk.mybatis.mapper.common.Mapper<ChangeConfig> {

    @Select("select * from TB_YX_QC_CHANGE_CONFIG where id = #{id}")
    ChangeConfig queryById(@Param("id") Long id);

    @Delete("delete from TB_YX_QC_CHANGE_CONFIG where id = #{id}")
    void deleteById(@Param("id") Long id);

    List<ChangeConfigPo> selectChangeConfigPo(ChangeConfigQueryReq req);

    List<ChangeType> queryByparentChangeClassId();
    //暂时弃用
    //ChangeExecConfigPo queryChangeDepartment(@Param("id")Long id);

    void add(ChangeConfig changeConfig);
}