/**
 * @(#)DESExport.java, 2022/12/8.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.netease.mail.dp.des.common.api.enums.DataType;
import com.netease.mail.dp.des.common.api.enums.TaskType;
import com.netease.mail.dp.des.common.api.query.CallbackQueryParam;
import com.netease.mail.dp.des.interaction.api.req.TaskReq;
import com.netease.mail.dp.des.starter.client.DesClient;
import com.netease.mail.yanxuan.change.biz.config.AppConfig;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowRequest;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigQueryReq;

/**
 * @Author zcwang
 * @Date 2022/12/8
 */
@Component
@Slf4j
public class DESExportService {

    @Autowired
    private DesClient desClient;

    @Autowired
    private AppConfig appConfig;

    public String changeFlowExport(ChangeFlowRequest query) {
        TaskReq taskReq = new TaskReq();
        taskReq.setUserEmail(query.getUid());
        taskReq.setProductCode(query.getServiceCode());
        taskReq.setFileName("变更管理列表导出");
        taskReq.setTaskType(TaskType.BIVARIATE);
        taskReq.setDataType(DataType.CALLBACK);
        CallbackQueryParam callbackQueryParam = new CallbackQueryParam();
        callbackQueryParam.setParamJson(JSON.toJSONString(query));
        callbackQueryParam.setCallbackBeanName("changeFlowExportCallback");
        callbackQueryParam.setLimit(appConfig.getExportLimit());
        taskReq.setCallbackQueryParam(callbackQueryParam);
        String desResult = desClient.addTask(taskReq);
        log.info("create task result: {}", desResult);
        return desResult;
    }
    
    public String changeConfigExport(ChangeConfigQueryReq query, String uid, String serviceCode) {
        TaskReq taskReq = new TaskReq();
        taskReq.setUserEmail(uid);
        taskReq.setProductCode(serviceCode);
        taskReq.setFileName("变更配置列表导出");
        taskReq.setTaskType(TaskType.BIVARIATE);
        taskReq.setDataType(DataType.CALLBACK);
        CallbackQueryParam callbackQueryParam = new CallbackQueryParam();
        callbackQueryParam.setParamJson(JSON.toJSONString(query));
        callbackQueryParam.setCallbackBeanName("changeConfigExportCallback");
        callbackQueryParam.setLimit(appConfig.getExportLimit());
        taskReq.setCallbackQueryParam(callbackQueryParam);
        String desResult = desClient.addTask(taskReq);
        log.info("create change config export task result: {}", desResult);
        return desResult;
    }
}