package com.netease.mail.yanxuan.change.integration.email.service.impl;

import com.netease.mail.yanxuan.change.integration.email.email.EmailFactor;
import com.netease.mail.yanxuan.change.integration.email.service.IEmailService;
import com.netease.mail.yanxuan.change.integration.email.enums.EmailParamEnum;
import com.netease.mail.yanxuan.change.integration.email.enums.EmailTemplateEnum;

import com.netease.mail.yanxuan.change.common.util.RequestUtil;
import com.netease.mail.yanxuan.qc.service.client.remote.UasClient;
import com.netease.mail.yanxuan.qc.service.client.utils.http.HttpClientTemplate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class EmailServiceImpl implements IEmailService {

    @Autowired
    private UasClient uasClient;

    @Autowired
    private EmailTemplateServiceImpl emailTemplateService;

    @Autowired
    private HttpClientTemplate httpClientTemplate;

    @PostConstruct
    private void init() {
        httpClientTemplate.init();
        httpClientTemplate.setDefaultCharset(RequestUtil.CHAR_SET);
    }

    @Override
    @Async("asyncEmail")
    public void sendEmail(String to, EmailFactor emailFactor) {
        this.sendEmail(to, null, emailFactor, null);
    }

    @Override
    @Async("asyncEmail")
    public void sendEmail(Collection<String> toList, EmailFactor factor) {
        this.sendEmail(toList, null, factor, null);
    }

    @Override
    @Async("asyncEmail")
    public void sendEmail(String toList, String ccList, EmailFactor factor, List<File> fileList) {
        List<String> _toList = null;
        List<String> _ccList = null;
        if (StringUtils.isNotBlank(toList)) {
            _toList = Arrays.asList(toList.split(","));
        }

        if (StringUtils.isNotBlank(ccList)) {
            _ccList = Arrays.asList(ccList.split(","));
        }
        this.sendEmail(_toList, _ccList, factor, fileList);
    }

    @Override
    @Async("asyncEmail")
    public void sendEmail(Collection<String> toList, Collection<String> ccList,
                          EmailFactor factor) {
        if (factor != null) {
            String content = this.content(factor);
            if (!CollectionUtils.isEmpty(toList)) {
                toList = toList.stream().filter(e -> e != null).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty(ccList)) {
                ccList = ccList.stream().filter(e -> e != null).collect(Collectors.toList());
            }
            this.uasClient.sendEmail(factor.getSubject(), content, toList, ccList, null);
        }
    }

    @Override
    @Async("asyncEmail")
    public void sendEmail(Collection<String> toList, Collection<String> ccList, EmailFactor factor,
                          List<File> fileList) {
        if (factor != null) {
            String content = this.content(factor);
            String abnormalTitle = (String) factor.getData().get("abnormalTitle");
            String taskType = (String) factor.getData().get(EmailParamEnum.TASK_TYPE.getKey());
            String subject = factor.getSubject();
            if (!StringUtils.isEmpty(abnormalTitle)) {
                subject = String.format(subject, abnormalTitle, taskType);
            }
            if (!StringUtils.isEmpty(taskType)) {
                subject = String.format(subject, taskType);
            }
            if (!CollectionUtils.isEmpty(toList)) {
                toList = toList.stream().filter(e -> e != null).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty(ccList)) {
                ccList = ccList.stream().filter(e -> e != null).collect(Collectors.toList());
            }
            this.uasClient.sendEmail(subject, content, toList, ccList, fileList);
        }
    }

    /**
     * 根据邮件模版获取邮件内容
     *
     * @param emailFactor
     * @return
     */
    public String content(EmailFactor emailFactor) {
        EmailTemplateEnum emailTemplateEnum = emailFactor.getEmailTemplateEnum();
        return emailTemplateService.template(emailTemplateEnum.getCode(), emailFactor.getData(),
                emailFactor.getType());
    }

}
