/**
 * @(#)TestController.java, 2022/11/28.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.web.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.biz.biz.ChangeFlowBiz;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2022/11/28
 */
@Slf4j
@RestController
@RequestMapping("/test")
public class TestController {

    @Autowired
    private ChangeFlowBiz changeFlowBiz;

    @PostMapping("/createToDo")
    public AjaxResult<Void> createTodoTask(ChangeRecord entity) {
        log.info("[createToDoTask] entity:{}", JSON.toJSONString(entity));
        changeFlowBiz.createSupplierTodoTask(entity);
        return AjaxResult.success();
    }

    @PostMapping("/finishToDo")
    public AjaxResult<Void> finishTodoTask(ChangeRecord entity) {
        log.info("[createToDoTask] entity:{}", JSON.toJSONString(entity));
        changeFlowBiz.createSupplierTodoTask(entity);
        return AjaxResult.success();
    }
}