/**
 * @(#)ChangeSubFlowSubmitReq.java, 2025/01/18.
 * <p/>
 * Copyright 2025 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.meta.model.req;

import javax.validation.constraints.NotBlank;
import java.util.List;

import lombok.Data;

/**
 * 子流程提交请求
 * @Author zcwang
 * @Date 2025/01/18
 */
@Data
public class ChangeSubFlowSubmitReq {

    /**
     * 子流程工单id
     */
    @NotBlank(message = "子流程工单id不能为空")
    private String subFlowId;

    /**
     * 当前节点id
     */
    @NotBlank(message = "当前节点不能为空")
    private String currentNodeId;

    /**
     * 行动完成时间（提交执行结果时必填）
     */
    private Long changeExecFinishTime;

    /**
     * 行动完成情况（提交执行结果时必填）
     */
    private String changeExecFinishDesc;

    /**
     * 行动项列表（确认行动方案时使用）
     */
    private List<ChangeExecConfigReq> changeExecProjectList;
}

