/**
 * @(#)ChangeFlowEnum.java, 2022/11/16.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.common.enums;

import lombok.Getter;

/**
 * @Author zcwang
 * @Date 2022/11/16
 */
public enum ChangeFlowEnum {
    /**
     * 老工作流
     */
    CHANGE_FLOW("0000", "全链路变更", "qc-change-flow"),
    CHANGE_FLOW_START("79560500", "开始节点", "qc-change-flow"),
    CHANGE_FLOW_SUBMIT("79560501", "变更申请提交", "qc-change-flow"),
    CHANGE_FLOW_EXE("79560502","变更执行", "qc-change-flow"),
    CHANGE_FLOW_CONFIRM("79560503","变更结果确认", "qc-change-flow"),
    END("9999", "结束", "qc-change-flow"),
    /**
     * 新工作流
     */
    NEW_CHANGE_FLOW("0000", "全链路变更", "yanxuan-qc-change-flow"),
    NEW_CHANGE_FLOW_START("79560701", "提交变更申请", "yanxuan-qc-change-flow"),
    NEW_CHANGE_FLOW_CONFIRM_EXEC_PLAN("79560702", "确认变更方案", "yanxuan-qc-change-flow"),
    NEW_CHANGE_FLOW_OWNER_APPROVE("79560703","部门负责人审批", "yanxuan-qc-change-flow"),
    NEW_CHANGE_FLOW_ADMIN_APPROVE("79560704","变更管理员审批", "yanxuan-qc-change-flow"),
    NEW_CHANGE_FLOW_QUALITY_APPROVE("79560705","质量部负责人审批", "yanxuan-qc-change-flow"),
    NEW_CHANGE_FLOW_EXE("79560706","执行变更方案", "yanxuan-qc-change-flow"),
    NEW_CHANGE_FLOW_CONFIRM("79560707","确认变更结果", "yanxuan-qc-change-flow"),
    NEW_END("9999", "结束", "yanxuan-qc-change-flow"),
    /**
     * 子工作流
     */
    CHANGE_SUB_FLOW("0000", "全链路变更子工单", "qc-change-sub-flow"),
    CHANGE_SUB_FLOW_START("79560601", "确认行动方案", "qc-change-sub-flow"),
    CHANGE_SUB_FLOW_SUBMIT("79560602", "审批行动方案", "qc-change-sub-flow"),
    CHANGE_SUB_FLOW_EXE("79560603","审批变更方案", "qc-change-sub-flow"),
    CHANGE_SUB_FLOW_CONFIRM("79560604","提交执行结果", "qc-change-sub-flow"),
    SUB_FLOW_END("9999", "结束", "qc-change-sub-flow");

    @Getter
    private final String nodeId;

    @Getter
    private final String name;

    @Getter
    private final String topoId;

    ChangeFlowEnum(String nodeId, String name, String topoId) {
        this.nodeId = nodeId;
        this.name = name;
        this.topoId = topoId;
    }

    public static ChangeFlowEnum getByNodeId(String nodeId) {
        for (ChangeFlowEnum value : ChangeFlowEnum.values()) {
            if (value.getNodeId().equals(nodeId)) {
                return value;
            }
        }
        return null;
    }
}