/**
 * @(#)ChangeSubFlowVO.java, 2024/01/01.
 * <p/>
 * Copyright 2024 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.meta.model.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 变更行动工单VO
 *
 * @Author system
 * @Date 2024/01/01
 */
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Data
public class ChangeSubFlowVO {
    /**
     * 变更行动ID（subFlowId）
     */
    private String subFlowId;

    /**
     * 变更ID（主单的flowId）
     */
    private Long flowId;

    /**
     * 变更行动人邮箱
     */
    private String changeExecUserEmail;

    /**
     * 变更行动人姓名
     */
    private String changeExecUserName;

    /**
     * 变更行动人（姓名+邮箱）
     */
    private String changeExecUserView;

    /**
     * 变更行动部门
     */
    private String changeExecDepartment;

    /**
     * 行动工单状态
     * @see com.netease.mail.yanxuan.change.common.enums.ChangeSubFlowStatusEnum
     */
    private Integer status;

    /**
     * 行动工单状态描述
     */
    private String statusDesc;

    /**
     * 行动完成时间（变更行动工单的完成时间，或预期完成时间）
     */
    private Long changeExecFinishTime;

    /**
     * 创建时间（行动工单发起时间）
     */
    private Long createTime;

    /**
     * 子单归属关系（标识当前用户与子单的归属关系）
     */
    private ChangeSubFlowOwnershipVO flowOwnership;
}

