/**
 * @(#)FlowRpcService.java, 2022/11/16.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.integration.flow;

import java.util.List;

import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;

import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;
import com.netease.yanxuan.flowx.sdk.meta.dto.base.FlowDataDTO;
import com.netease.yanxuan.flowx.sdk.meta.dto.flow.FlowCreateReqDTO;
import com.netease.yanxuan.flowx.sdk.meta.dto.flow.NodeSubmitReqDTO;
import com.netease.yanxuan.flowx.sdk.meta.dto.flow.UpdateNodeApproverDTO;
import com.netease.yanxuan.missa.client.annotation.MissaClient;

/**
 * @Author zcwang
 * @Date 2022/11/16
 */
@Service
@MissaClient(serviceCode = "yanxuan-flowx-server")
public interface FlowRpcService {

    /**
     * 创建流转工单
     *
     * @param product
     * @param req
     * @return
     */
    @PostMapping(value = "/{product}/workOrderFlow/v1/create", consumes = MediaType.APPLICATION_JSON_VALUE)
    AjaxResponse<String> create(@PathVariable("product") String product, FlowCreateReqDTO req);

    /**
     * 工单详情查询
     * @param flowxProduct
     * @param flowId
     * @return
     */
    @GetMapping(value = "/{product}/workOrder/v1/{flowId}/detail")
    AjaxResponse<FlowDataDTO> getDetail(@PathVariable("product") String flowxProduct,
        @PathVariable("flowId") String flowId);


    /**
     * 工单提交
     * @param flowxProduct
     * @param nodeSubmitReqDTO
     * @return
     */
    @PostMapping(value = "/{product}/workOrderFlow/v1/submit", consumes = MediaType.APPLICATION_JSON_VALUE)
    AjaxResponse<List<String>> submit(@PathVariable("product") String flowxProduct, NodeSubmitReqDTO nodeSubmitReqDTO);

    /**
     * 更新待办负责人
     * @param flowxProduct
     * @param approverDTO
     */
    @PutMapping(value = "/{product}/workOrderFlow/v1/approvers/update", consumes = MediaType.APPLICATION_JSON_VALUE)
    void updateApprovers(@PathVariable("product")String flowxProduct, UpdateNodeApproverDTO approverDTO);
}
