package com.netease.mail.yanxuan.change.web.controller;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.biz.config.AppConfig;
import com.netease.mail.yanxuan.change.biz.service.ISupplierItemService;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.common.bean.ResponseCodeEnum;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierInfoService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierSendService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierGoodsInfoReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierSearchRemoteReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.ItemSupplierRsp;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierSimpleRsp;
import com.netease.mail.yanxuan.change.integration.todo.SupplierItemPageVO;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;

import lombok.extern.slf4j.Slf4j;

/**
 * @author WangJiaXiang
 * @date 2022/12/7/007$
 */
@Slf4j
@RestController
@RequestMapping("/supplier")
public class SupplierController {

    @Autowired
    private FlowRpcSupplierService rpcSupplierService;

    @Autowired
    private ISupplierItemService supplierItemService;

    @Autowired
    private FlowRpcSupplierSendService supplierSendService;

    @Autowired
    private FlowRpcSupplierInfoService flowRpcSupplierInfoService;

    @Autowired
    private AppConfig appConfig;

    @GetMapping("/query/supplier/infos")
    public AjaxResult<List<SupplierSimpleRsp>> querySupplierInfos(
        @RequestParam(name = "name", required = false) String name,
        @RequestParam(name = "uid", required = false) String uid,
        @RequestParam(name = "fuzzySearchText") String fuzzySearchText) {
        SupplierSearchRemoteReq req = new SupplierSearchRemoteReq();
        req.setSearchText(fuzzySearchText);
        AjaxResult<List<SupplierSimpleRsp>> supplierInfo = supplierSendService.queryByConditionForQc(req);
        if (ResponseCodeEnum.SUCCESS.getCode() == (supplierInfo.getCode())) {
            return supplierInfo;
        }
        log.error("[querySupplierInfos] querySupplierInfos failed, name={},uid={},fuzzySearchText={}, errMsg={}", name,
            uid, fuzzySearchText, JSON.toJSONString(supplierInfo));
        return null;
    }

    @GetMapping("/query/supplier/item")
    public AjaxResponse<SupplierItemPageVO> querySupplier(@RequestParam String supplier,
        @RequestParam(required = false) String itemId, @RequestParam(required = false) String itemName,
        @RequestParam(required = false) String skuId, @RequestParam(defaultValue = "1") Integer page,
        @RequestParam(defaultValue = "10") Integer pageSize) {
        SupplierGoodsInfoReq supplierGoodsInfoReq = new SupplierGoodsInfoReq();
        supplierGoodsInfoReq.setSupplierIds(supplier);
        return AjaxResponse.initSuccessResult(supplierItemService.supplierGoodsInfoBySupplier(supplierGoodsInfoReq,
            itemId, itemName, page, pageSize, skuId));
    }

    /**
     * 根据商品Id列表查询供应商（新）
     * 
     * @param itemIds 商品Id列表（可通过多个同名参数传递，如：?itemId=1&itemId=2&itemId=3）
     * @return 供应商信息列表（去重后）
     */
    @GetMapping("/query/supplier/by/item/ids")
    public AjaxResult<List<SupplierSimpleRsp>> querySupplierByItemIds(@RequestParam(name = "itemId") List<Long> itemIds) {
        // 获取元数据
        List<ItemSupplierRsp> itemSupplierList = flowRpcSupplierInfoService.querySupplierByItemIds(itemIds);
        
        // 打印元数据日志
        log.info("[querySupplierByItemIds] 元数据 itemIds={}, itemSupplierList={}", 
            JSON.toJSONString(itemIds), JSON.toJSONString(itemSupplierList));

        String detail = supplierSendService.queryGoodsPurchase(itemIds);
        log.info("[queryGoodsCommander] purchase:{}", detail);

        if (CollectionUtils.isEmpty(itemSupplierList)) {
            return AjaxResult.success(new ArrayList<>());
        }
        
        // 从响应中提取供应商信息，并去重（按supplierId去重）
        Set<String> supplierIdSet = new HashSet<>();
        List<SupplierSimpleRsp> supplierList = new ArrayList<>();
        
        for (ItemSupplierRsp itemSupplier : itemSupplierList) {
            String supplierId = itemSupplier.getSupplierId();
            String supplierName = itemSupplier.getSupplierName();
            
            // 如果供应商ID为空，跳过
            if (StringUtils.isBlank(supplierId)) {
                continue;
            }
            
            // 去重：如果该供应商ID已经处理过，跳过
            if (supplierIdSet.contains(supplierId)) {
                continue;
            }
            
            supplierIdSet.add(supplierId);
            
            // 构建供应商信息
            SupplierSimpleRsp supplier = new SupplierSimpleRsp();
            supplier.setSupplierId(supplierId);
            supplier.setSupplierName(StringUtils.isNotBlank(supplierName) ? supplierName : supplierId);
            supplierList.add(supplier);
        }
        
        log.info("[querySupplierByItemIds] itemIds={}, supplierCount={}", JSON.toJSONString(itemIds), supplierList.size());
        return AjaxResult.success(supplierList);
    }

}
