/**
 * @(#)FlowRpcService.java, 2022/11/16.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.integration.todo;

import java.util.List;

import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;

import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;
import com.netease.yanxuan.flowx.sdk.meta.dto.base.FlowDataDTO;
import com.netease.yanxuan.flowx.sdk.meta.dto.flow.NodeSubmitReqDTO;
import com.netease.yanxuan.missa.client.annotation.MissaClient;

/**
 * @Author zcwang
 * @Date 2022/11/16
 */
@Service
@MissaClient(serviceCode = "yanxuan-sc-todo-center")
public interface TodoRpcService {

    /**
     * 创建待办
     * @param param
     * @return
     */
    @PostMapping(value = "/xhr/todo/task/create.json", consumes = MediaType.APPLICATION_JSON_VALUE)
    AjaxResponse<TaskCreateDTO> create(TaskCreateParamVO param);

    /**
     * 处理待办
     * @param param
     * @return
     */
    @PostMapping(value = "/xhr/todo/task/process.json", consumes = MediaType.APPLICATION_JSON_VALUE)
    AjaxResponse<List<String>> progress(TaskProcessParamVO param);
}
