/**
 * @(#)TestController.java, 2022/11/28.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.web.controller;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.biz.biz.ChangeFlowBiz;
import com.netease.mail.yanxuan.change.biz.config.AppConfig;
import com.netease.mail.yanxuan.change.biz.meta.exception.ExceptionFactory;
import com.netease.mail.yanxuan.change.biz.service.ChangeFlowService;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeConfigService;
import com.netease.mail.yanxuan.change.biz.service.rpc.SupplierSendService;
import com.netease.mail.yanxuan.change.biz.service.rpc.TodoService;
import com.netease.mail.yanxuan.change.biz.task.AutoSubmit;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.common.bean.RequestLocalBean;
import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.common.enums.ChangeFlowEnum;
import com.netease.mail.yanxuan.change.common.enums.CreateSourceEnum;
import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeConfigPo;
import com.netease.mail.yanxuan.change.dal.meta.model.req.SendMailReq;
import com.netease.mail.yanxuan.change.integration.email.enums.EmailTemplateEnum;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierInfoService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierRelatedUserReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierUserRsp;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2022/11/28
 */
@Slf4j
@RestController
@RequestMapping("/test")
public class TestController {

    @Autowired
    private TodoService todoService;

    @Autowired
    private ChangeFlowService changeFlowService;

    @Autowired
    private AutoSubmit autoSubmit;

    @Autowired
    private ChangeFlowBiz changeFlowBiz;

    @Autowired
    private AppConfig appConfig;

    @Autowired
    private SupplierSendService sendSupplierEmail;

    @Autowired
    private ChangeConfigService changeConfigService;

    @PostMapping("/createToDo")

    public AjaxResult<Void> createTodoTask(ChangeRecord entity) {
        log.info("[createToDoTask] entity:{}", JSON.toJSONString(entity));
        todoService.createTodoTask(entity);
        return AjaxResult.success();
    }

    @PostMapping("/progressTodo")
    public AjaxResult<Void> progressTodoTask(ChangeRecord entity, Integer operateType) {
        log.info("[createToDoTask] entity:{}, operateType:{}", JSON.toJSONString(entity), operateType);
        todoService.progressTodoTask(entity, operateType);
        return AjaxResult.success();
    }


    @PostMapping("/submit")
    public AjaxResult<Void> submit(Long id) {
        ChangeRecord record = changeFlowService.getById(id);
        Assert.notNull(record, "工单不存在");
        if (!record.getFlowNode().equals(ChangeFlowEnum.CHANGE_FLOW_EXE.getNodeId())) {
            throw ExceptionFactory.createBiz(ResponseCode.SUBMIT_FLOW_ERROR, "不是变更执行节点，不可运维提交");
        }
        autoSubmit.progressRecord(record);
        return AjaxResult.success();
    }

    @GetMapping("/getUid")
    public AjaxResult<String> getUid() {
        return AjaxResult.success(RequestLocalBean.getUid());
    }

    @Autowired
    private FlowRpcSupplierInfoService supplierInfoService;

    @PostMapping("/test")
    public List<SupplierUserRsp> test(@RequestBody SupplierRelatedUserReq req) {
        return supplierInfoService.querySupplierRelatedUser(req);
    }

    @PostMapping("/send")
    public void sendEmail(@RequestBody SendMailReq req) {
        String subjectParam = req.getId().toString();
        EmailTemplateEnum emailTemplateEnum = EmailTemplateEnum.getEmailTemplateEnum(req.getCode());
        String mapToJson = req.getMapToJson();
        log.debug("[testSendEmail] subjectParam:{}, emailTemplateEnum:{}, mapToJson:{}", subjectParam,
            emailTemplateEnum, mapToJson);
        changeFlowBiz.qcSendEmail(appConfig.getReceiver(), appConfig.getReceiver(), subjectParam,
                        emailTemplateEnum, JSON.parseObject(mapToJson, Map.class));
        // 如果是供应商，再次发送供应商邮件
        if (req.getCreateSource().equals(CreateSourceEnum.TONG_ZHOU.getType())) {
            Assert.notNull(req.getChangeSupplier(), "同舟端负责人不可为空");
            sendSupplierEmail.sendSupplierEmail(req.getChangeSupplier(), subjectParam,
                    emailTemplateEnum, JSON.parseObject(mapToJson, Map.class));
        }
    }

    @GetMapping("/ccList")
    public AjaxResult<List<String>> ccList(@RequestParam List<String> receiver){
        return AjaxResult.success(changeFlowBiz.getDepartmentInfo(receiver));
    }

    @GetMapping("/getByOneAndTwo")
    public AjaxResult<ChangeConfigPo> getByOneAndTwo(@RequestParam Long parentId, @RequestParam Long sonId) {
        return AjaxResult.success(changeConfigService.queryInfoPo(parentId, sonId));
    }
}