/**
 * @(#)ChangeSubFlowRecord.java, 2024/01/01.
 * <p/>
 * Copyright 2024 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.entity;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 变更行动工单
 * 关系：主单 1 - 变更行动工单 N - 行动项 N
 * 
 * @Author system
 * @Date 2024/01/01
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
@Entity
@Table(name = "TB_YX_QC_CHANGE_SUB_FLOW_RECORD")
public class ChangeSubFlowRecord {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 主单记录ID（变更记录ID）
     */
    private Long changeRecordId;

    /**
     * 变更行动工单ID（即topo）
     */
    private String subFlowId;

    /**
     * 变更行动工单当前节点
     */
    private String subFlowNode;

    /**
     * 变更行动工单状态
     * @see com.netease.mail.yanxuan.change.common.enums.ChangeSubFlowStatusEnum
     */
    private Integer status;

    /**
     * 变更行动工单审批人（JSON格式，存储审批人列表，第一次新建时就是行动人）
     * 格式：["user1@example.com", "user2@example.com"]
     */
    private String approver;

    /**
     * 变更行动人邮箱（用于查询和展示，新建时从行动项获取）
     */
    private String changeExecUserEmail;

    /**
     * 变更行动部门（用于查询和展示，新建时从行动项获取）
     */
    private String changeExecDepartment;

    /**
     * 创建时间
     */
    private Long createTime;

    /**
     * 更新时间
     */
    private Long updateTime;
}

