package com.netease.mail.yanxuan.change.integration.flow.goods;

import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;
import com.netease.yanxuan.flowx.sdk.meta.dto.base.FlowDataDTO;
import com.netease.yanxuan.missa.client.annotation.MissaClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author WangJiaXiang
 * @date 2022/11/24/024$
 * 查询商品BU
 */

@Service
@MissaClient(serviceCode = "yanxuan-itemcenter-admin")
public interface ItemcenterApiRpcService {

    /**
     * 根据商品Id 查询商品BU
     * @param goodsId
     * @return
     */
    @PostMapping(value = "/yxicadmin/api/xhr/item/group/itemIds.json")
    String getDetail(@RequestBody List<Long> goodsId);

    @GetMapping(value = "/yxicadmin/api/xhr/item/queryManagers")
    AjaxResponse<List<ItemManagerTO>> getProduct(@RequestParam(value = "product") String product, @RequestParam(value = "itemIds") String itemIds);

    /*
     *  调用案例
        SupplierSendEmailReq req = new SupplierSendEmailReq();
        req.setSupplierId("YX0001");
        req.setMailSubject("测试发送主题");
        req.setMailContent("测试发送内容");
        req.setIsAllAccountResolved(1);
        String s = sendEmailService.sendEmail(req);

    */



}
