/**
 * @(#)ChangeFileMapper.java, 2022/11/11.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import com.netease.mail.yanxuan.change.dal.entity.ChangeFile;

/**
 * @Author zcwang
 * @Date 2022/11/11
 */
@Mapper
public interface ChangeFileMapper extends tk.mybatis.mapper.common.Mapper<ChangeFile> {

    @Select("SELECT * FROM TB_YX_QC_CHANGE_FILE WHERE change_record_id = #{changeRecordId}")
    List<ChangeFile> selectByChangeRecordId(@Param("changeRecordId") Long changeRecordId);

    @Insert({ "<script>",
            "insert into TB_YX_QC_CHANGE_FILE(change_record_id, file_type, file_name, file_url, create_time, update_time) values ",
            "<foreach collection='list' item='item' index='index' separator=','>",
            "(#{item.changeRecordId}, #{item.fileType}, #{item.fileName}, #{item.fileUrl}, #{item.createTime}, #{item.updateTime})",
            "</foreach>", "</script>" })
    void insertList(List<ChangeFile> changeFiles);

    @Delete("delete from TB_YX_QC_CHANGE_FILE where change_record_id = #{changeRecordId}}")
    Integer deleteByBaseId(Long changeRecordId);
}